//Arduino Leonardo or Pro Micro using ATMega32u4    (SerialButtonBox3)
//2-Button asynchronous button box

const int externalLED = 9;     //digital line #9
const int digiInput1 = 5;      //digital input #1
const int digiInput2 = 6;      //digital input #2
const int digiInput3 = 7;      //digital input #3
unsigned long startTime = 0UL;
unsigned long endTime = 0UL;
unsigned long elapsedTime = 0UL;
char data;                     //serial char input data

//operalional parameters
int state = 0;                  //operational state: 0=stopped,1=scanning
unsigned long TIMEOUT = 5000UL; //RT trial timeout (5000 millisecs)

////////////////////////////////
// configure Arduino hardware //
////////////////////////////////
void setup() {
  pinMode(externalLED, OUTPUT);      //define LED digital output
  pinMode(digiInput1, INPUT_PULLUP); //define a digital input #1
  pinMode(digiInput2, INPUT_PULLUP); //define a digital input #2
  pinMode(digiInput3, INPUT_PULLUP); //define a digital input #3
  digitalWrite(externalLED, LOW);    //LED off
  elapsedTime = millis();
  Serial.begin(115200);  //initialize serial comm interface
}

//////////////////////////
//                      //
// main processing loop //
//                      //
//////////////////////////
void loop() {

  int loopflag;
  int activeInput;
  unsigned long timeout;
  
  //////////////////////
  // RT scanning loop //
  //////////////////////
  if(state == 1) {

    digitalWrite(externalLED, HIGH);  //turn-on LED
    activeInput = 0;
	  elapsedTime = 0UL;
	  startTime = millis();
	  timeout = startTime + TIMEOUT;
	  loopflag = 1;
	  while(loopflag) {
		   //scan inputs
		   if(digitalRead(digiInput1) == 0) {activeInput = 1;}
		   if(digitalRead(digiInput2) == 0) {activeInput = 2;}
       if(digitalRead(digiInput3) == 0) {activeInput = 3;}
		   //test for timeout
		   if(millis() >= timeout) {
          activeInput = 0;
          elapsedTime = TIMEOUT;
			    state = 0;
			    loopflag = 0;
          //Serial.println("Timed-out");
		   }
		   //test for button press
		   if(activeInput != 0) {
			    endTime = millis();
			    elapsedTime = endTime-startTime;
			    state = 0;
			    loopflag = 0;
          //Serial.println("Button press detected");
		   }
       //scan for serial input commands
       scanKey();
       if(state != 1) {break;}
       
	  }  //end while(loopflag)

    //send result via serial interface
    Serial.println(elapsedTime);
    Serial.println(activeInput);
    
    //turn-off LED
    digitalWrite(externalLED, LOW);
    
  } //end if(stat == 1)

  //check for input commands
  scanKey();
  
} //end loop()
  
 
/////////////////////////////////////////////////////////
//                                                     //
//scan serial input and interpret single-char commands //
//                                                     //
/////////////////////////////////////////////////////////
void scanKey() {
   if(Serial.available() > 0) {
       data = Serial.read();   //fetch char from serial input buffer
       //interpret serial input char
       switch(data) {
          case 'p':   //(P)ing command (used for baseline timing benchmarks)
             Serial.print("R");  //immediate single char serial reply
             break;
          case 'a':   //(A)bort reaction time trial
             state = 0;   //operational mode = stopped
             break;
          case 'r':   //begin (R)eaction Time trial 
             state = 1;   //operational mode = one-shot measurement
             break;
          case 'c':   //(C)lock
             startTime = millis();
             Serial.println(startTime);
             break;
          case '0':   //turn-off external LED
             digitalWrite(externalLED, LOW);
             break;
          case '1':   //turn-on external LED
             digitalWrite(externalLED, HIGH);
             break;
          case '2':   //update Timeout parameter
             TIMEOUT = 2000;
             break;
          case '3':   //update Timeout parameter
             TIMEOUT = 3000;
             break;
          case '4':   //update Timeout parameter
             TIMEOUT = 4000;
             break;
          case '5':   //update Timeout parameter
             TIMEOUT = 5000;
             break;
          case '6':   //update Timeout parameter
             TIMEOUT = 6000;
             break;
          case '7':   //update Timeout parameter
             TIMEOUT = 7000;
             break;
          case '8':   //update Timeout parameter
             TIMEOUT = 8000;
             break;
          case '9':   //update Timeout parameter
             TIMEOUT = 9000;
             break;
          case 'h':   //(H)ELP menu command
          case '?':
             Serial.println("Single Character Commands:");
             Serial.println("  a = (A)bort reaction time trial");
             Serial.println("  c = return Arduino (C)lock (microsecs)");
             Serial.println("  p = (P)ing the Arduino (immediate serial reply)");
             Serial.println("  r = begin (R)eaction time trial");
             Serial.println("  0 = LED Off");
             Serial.println("  1 = LED On");
             Serial.println("  2 = set timeout to 2 seconds");
             Serial.println("  3 = set timeout to 3 seconds");
             Serial.println(" use 4 thru 9 for 4-9 sec timeouts");
             break;
          default:
             break;
       } //end switch()
    } //end Serial.available()
} //end scanKey()
