#benchmark_RNG.py
#Compute descriptive statistics and plot distribution
#of random numbers generated by Arduino random(10,61) command

import numpy as np
import matplotlib.pyplot as plt  #MATLAB plot library
import sys

filename = 'random_10_61.txt'   #data file captured by Putty

#load data from comma-delimited file
#format: col-0=sample number, col-1=random number
data = np.loadtxt(filename,delimiter=',',skiprows=1)

#compute descriptive statistics (column-1)
rng_mean = np.mean(data[:,1])
rng_std = np.std(data[:,1])
rng_min = np.min(data[:,1])
rng_max = np.max(data[:,1])
reps = len(data[:,1]) #number of samples


#plot distribution of latency measurements using MATPLOTLIB
n, bins, patches = plt.hist(data[:,1],facecolor='g',alpha=0.75)
plt.xlabel('Random Value')
plt.ylabel('Frequency')
plt.title('Distribution of %i Samples\nMean: %f, SD: %f, Min: %f, Max: %f' %
          (reps,rng_mean,rng_std,rng_min,rng_max))
plt.grid(True)
plt.show()
