VERSION 5.00
Object = "{C1A8AF28-1257-101B-8FB0-0020AF039CA3}#1.1#0"; "MCI32.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "Comdlg32.ocx"
Begin VB.Form frmMediaViewer 
   Caption         =   "ETS Media Explorer - 3M Cottage Grove Track - July 2002"
   ClientHeight    =   10320
   ClientLeft      =   705
   ClientTop       =   1275
   ClientWidth     =   12705
   ForeColor       =   &H80000008&
   Icon            =   "MediaViewer.frx":0000
   LinkTopic       =   "Form1"
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   10320
   ScaleWidth      =   12705
   Begin VB.CommandButton cmdSaveDataLog 
      Caption         =   "Save Log"
      Enabled         =   0   'False
      Height          =   255
      Left            =   9000
      TabIndex        =   43
      Top             =   9960
      Width           =   975
   End
   Begin VB.TextBox txtMemo 
      Height          =   285
      Left            =   9480
      TabIndex        =   42
      Top             =   9240
      Width           =   2535
   End
   Begin VB.CommandButton cmdFixationNext 
      Caption         =   ">"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   11520
      TabIndex        =   41
      Top             =   9600
      Width           =   375
   End
   Begin VB.CommandButton cmdFixationBack 
      Caption         =   "<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   11160
      TabIndex        =   40
      Top             =   9600
      Width           =   375
   End
   Begin VB.TextBox txtFixation 
      Height          =   285
      Left            =   10680
      TabIndex        =   39
      Text            =   "1"
      Top             =   9600
      Width           =   375
   End
   Begin VB.CommandButton cmdRecordData 
      Caption         =   "Log Data"
      Enabled         =   0   'False
      Height          =   255
      Left            =   9000
      TabIndex        =   36
      Top             =   9600
      Width           =   975
   End
   Begin VB.ComboBox lstSignPost 
      Height          =   315
      ItemData        =   "MediaViewer.frx":0442
      Left            =   7200
      List            =   "MediaViewer.frx":0444
      Style           =   2  'Dropdown List
      TabIndex        =   35
      Top             =   9240
      Width           =   1575
   End
   Begin VB.CommandButton cmdUpdateStart 
      Caption         =   "Update Start"
      Height          =   255
      Left            =   5880
      TabIndex        =   34
      Top             =   8400
      Width           =   1215
   End
   Begin VB.TextBox txtDistance 
      Height          =   285
      Left            =   7200
      TabIndex        =   25
      Top             =   9600
      Width           =   1575
   End
   Begin VB.CommandButton cmdDistance 
      Caption         =   "Distance"
      Enabled         =   0   'False
      Height          =   255
      Left            =   6240
      TabIndex        =   24
      Top             =   9600
      Width           =   855
   End
   Begin VB.CommandButton cmdPlay 
      Caption         =   "&Play"
      Height          =   375
      Left            =   1200
      TabIndex        =   23
      Top             =   7920
      Width           =   1215
   End
   Begin VB.CommandButton cmdPause 
      Caption         =   "P&ause"
      Height          =   375
      Left            =   2400
      TabIndex        =   22
      Top             =   7920
      Width           =   1215
   End
   Begin VB.CommandButton cmdVideo 
      Caption         =   "&Change Video"
      Height          =   375
      Left            =   0
      TabIndex        =   21
      Top             =   7920
      Width           =   1215
   End
   Begin VB.TextBox txtNFrames 
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   1200
      Locked          =   -1  'True
      TabIndex        =   20
      Text            =   "0"
      ToolTipText     =   "Length of current video (read only)"
      Top             =   8400
      Width           =   735
   End
   Begin VB.TextBox txtFrameStart 
      Alignment       =   1  'Right Justify
      Height          =   285
      Left            =   3000
      TabIndex        =   19
      Text            =   "0"
      Top             =   8400
      Width           =   735
   End
   Begin VB.TextBox txtCurrentFrame 
      Alignment       =   1  'Right Justify
      Appearance      =   0  'Flat
      Height          =   285
      Left            =   4920
      Locked          =   -1  'True
      TabIndex        =   18
      Top             =   8400
      Width           =   855
   End
   Begin VB.CommandButton cmdFrameBack 
      Caption         =   "<"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   3840
      TabIndex        =   17
      Top             =   7920
      Width           =   375
   End
   Begin VB.CommandButton cmdFrameForward 
      Caption         =   ">"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   435
      Left            =   4200
      TabIndex        =   16
      Top             =   7920
      Width           =   375
   End
   Begin VB.CommandButton cmdLoadData 
      Caption         =   "&Load Data"
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Top             =   8760
      Width           =   1215
   End
   Begin VB.TextBox txtCurrentData 
      Height          =   375
      Left            =   2880
      TabIndex        =   14
      Text            =   "none"
      Top             =   8760
      Width           =   2175
   End
   Begin VB.TextBox txtLatitude 
      Height          =   285
      Left            =   600
      TabIndex        =   13
      Top             =   9600
      Width           =   1335
   End
   Begin VB.TextBox txtLongitude 
      Height          =   285
      Left            =   2760
      TabIndex        =   12
      Top             =   9600
      Width           =   1335
   End
   Begin VB.TextBox txtDataLine 
      Height          =   285
      Left            =   720
      TabIndex        =   11
      Top             =   9240
      Width           =   975
   End
   Begin VB.CommandButton cmdBackData 
      Caption         =   "Back"
      Enabled         =   0   'False
      Height          =   295
      Left            =   3720
      TabIndex        =   10
      Top             =   9240
      Width           =   550
   End
   Begin VB.CommandButton cmdNextData 
      Caption         =   "Next"
      Enabled         =   0   'False
      Height          =   295
      Left            =   4320
      TabIndex        =   9
      Top             =   9240
      Width           =   550
   End
   Begin VB.CommandButton cmdSyncData 
      Caption         =   "Sync On"
      Enabled         =   0   'False
      Height          =   295
      Left            =   4920
      TabIndex        =   8
      Top             =   9240
      Width           =   855
   End
   Begin VB.TextBox txtGPSTime 
      Height          =   285
      Left            =   4920
      TabIndex        =   7
      Top             =   9600
      Width           =   1215
   End
   Begin VB.CommandButton cmdLatSearch 
      Caption         =   "Lat"
      Enabled         =   0   'False
      Height          =   255
      Left            =   0
      TabIndex        =   6
      Top             =   9600
      Width           =   495
   End
   Begin VB.CommandButton cmdLongSearch 
      Caption         =   "Long"
      Enabled         =   0   'False
      Height          =   255
      Left            =   2040
      TabIndex        =   5
      Top             =   9600
      Width           =   615
   End
   Begin VB.CommandButton cmdTimeSearch 
      Caption         =   "Time"
      Enabled         =   0   'False
      Height          =   255
      Left            =   4200
      TabIndex        =   4
      Top             =   9600
      Width           =   615
   End
   Begin VB.TextBox txtRealLine 
      Height          =   285
      Left            =   2640
      TabIndex        =   3
      Top             =   9240
      Width           =   975
   End
   Begin VB.Timer Timer1 
      Interval        =   5000
      Left            =   11280
      Top             =   960
   End
   Begin VB.PictureBox Picture1 
      BackColor       =   &H00FFFFFF&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   7815
      Left            =   0
      ScaleHeight     =   7755
      ScaleWidth      =   9915
      TabIndex        =   0
      Top             =   0
      Width           =   9975
      Begin VB.Label Label1 
         BackStyle       =   0  'Transparent
         Caption         =   "Video output is in the Video window. To turn this option off, do the following:"
         Height          =   2535
         Left            =   840
         TabIndex        =   2
         Top             =   720
         Visible         =   0   'False
         Width           =   4695
      End
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   10680
      Top             =   960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      DialogTitle     =   "Choose Video"
      Filter          =   "Video for Windows Files (*.MPG)|*.MPG|All Files|*.*"
   End
   Begin MCI.MMControl MMControl1 
      Height          =   435
      Left            =   10200
      TabIndex        =   1
      Top             =   960
      Visible         =   0   'False
      Width           =   420
      _ExtentX        =   741
      _ExtentY        =   767
      _Version        =   393216
      PrevVisible     =   0   'False
      NextVisible     =   0   'False
      PlayVisible     =   0   'False
      PauseVisible    =   0   'False
      BackVisible     =   0   'False
      StepVisible     =   0   'False
      StopVisible     =   0   'False
      RecordVisible   =   0   'False
      EjectVisible    =   0   'False
      DeviceType      =   ""
      FileName        =   ""
   End
   Begin VB.Shape boxDataLogging 
      Height          =   1215
      Left            =   8880
      Top             =   9120
      Width           =   3255
   End
   Begin VB.Label lblFixation 
      Caption         =   "Fixation:"
      Height          =   255
      Left            =   10080
      TabIndex        =   38
      Top             =   9600
      Width           =   615
   End
   Begin VB.Label lblMemo 
      Caption         =   "Memo:"
      Height          =   255
      Left            =   9000
      TabIndex        =   37
      Top             =   9240
      Width           =   495
   End
   Begin VB.Label lblNFrames 
      Caption         =   "Length (Frames)"
      Height          =   255
      Left            =   0
      TabIndex        =   33
      Top             =   8400
      Width           =   1215
   End
   Begin VB.Label lblFrameStart 
      Caption         =   "Start Frame:"
      Height          =   255
      Left            =   2040
      TabIndex        =   32
      Top             =   8400
      Width           =   855
   End
   Begin VB.Label lblCurrentFrame 
      Caption         =   "Current Frame:"
      Height          =   255
      Left            =   3840
      TabIndex        =   31
      Top             =   8400
      Width           =   1215
   End
   Begin VB.Label Label2 
      Caption         =   "Current Data File:"
      Height          =   255
      Left            =   1440
      TabIndex        =   30
      Top             =   8880
      Width           =   1335
   End
   Begin VB.Label lblLatitude 
      Caption         =   "Lat"
      Height          =   255
      Left            =   1080
      TabIndex        =   29
      Top             =   9960
      Width           =   255
   End
   Begin VB.Label lblSignPost 
      Caption         =   "Select Sign Post:"
      Height          =   255
      Left            =   5880
      TabIndex        =   28
      Top             =   9240
      Width           =   1335
   End
   Begin VB.Label lblCurrentLine 
      Caption         =   "File Line:"
      Height          =   255
      Left            =   0
      TabIndex        =   27
      Top             =   9240
      Width           =   975
   End
   Begin VB.Label lblRealLine 
      Caption         =   "(Real Line):"
      Height          =   255
      Left            =   1800
      TabIndex        =   26
      Top             =   9240
      Width           =   855
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu cvf 
         Caption         =   "&Choose Video File..."
      End
      Begin VB.Menu mnuSeperator 
         Caption         =   "-"
      End
      Begin VB.Menu mnuExit 
         Caption         =   "E&xit"
      End
   End
   Begin VB.Menu mnuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAVIView 
         Caption         =   "&About..."
      End
   End
   Begin VB.Menu filelabel 
      Caption         =   "Current Video: none"
   End
End
Attribute VB_Name = "frmMediaViewer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'''''''''''''''''''''''''''''''''''''''''''''''''''''
' ETS Media Explorer Application                    '
' Heimstra Human Factors Labs                       '
' University of South Dakota                        '
'                                                   '
' 3M Cottage Grove Test Track Version 1.0           '
'                                                   '
' September 20, 2002    fjs                         '
'''''''''''''''''''''''''''''''''''''''''''''''''''''
'
' Large Screen Version
' Distance Calculations currently referenced to 3M-Track Sign #2
'
'
'Edit History
'9-18-02 Modify search for Lat/Time to always start at Line 1
'        Long search still starts at current data frame
'9-19-02 Increase size of Data Log data arrays
'9-20-02 Add data recording to MS-Word document
'
'
'DECLARATIONS for frmMediaViewer module
'
#If Win32 Then
    Private Declare Function mciSendString Lib "winmm.dll" Alias "mciSendStringA" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Long, ByVal hWndCallback As Long) As Long
#Else
    Private Declare Function mciSendString Lib "mmsystem" (ByVal lpstrCommand As String, ByVal lpstrReturnString As String, ByVal uReturnLength As Integer, ByVal hWndCallback As Integer) As Long
#End If
'
'Option Explicit
Option Base 1
'
'global variables
'
Dim intNFrames As Long       'length of media file
Dim syncFlag As Boolean      'enables Video-to-Data synchronization
Dim syncLine As Long
Dim syncFrame As Long
Dim bSignPostSelected As Boolean
Dim dLatitude2 As Double
Dim dLongitude2 As Double
Dim currentVideoFile As String
Dim currentDataFile As String
'
'Microsoft Word Object
Dim wordApp As Word.Application
Dim wordFlag As Boolean
'
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'
'Data Structures for DGPS Study
'
Dim fileSize As Integer

Private Const MAXCOUNT = 35000

Dim intRecno(MAXCOUNT) As Integer
Dim sTime(MAXCOUNT) As String * 10
Dim intLatency(MAXCOUNT) As Integer
Dim dLatitude(MAXCOUNT) As Double
Dim dLongitude(MAXCOUNT) As Double
Dim dSpeed(MAXCOUNT) As Double
Dim dHeading(MAXCOUNT) As Double
Dim dPDOP(MAXCOUNT) As Double
Dim dHDOP(MAXCOUNT) As Double
Dim intStatus(MAXCOUNT) As Integer
Dim lOdometer(MAXCOUNT) As Long
Dim lAngleRate(MAXCOUNT) As Long
Dim dIntAngle(MAXCOUNT) As Double
'
'
'stimulus sign coordinates - 3M Cottage Grove Track - July 2002
'(initialized in form_load subroutine)
Dim dSignLat(20) As Double
Dim dSignLong(20) As Double
'
'
'
'service request to go back one line of GPS DATA
'
Private Sub cmdBackData_Click()

   Dim dataLine As Long
   
   dataLine = CLng(txtDataLine.Text)
   dataLine = dataLine - 1
   If dataLine < 1 Then dataLine = 1
   If dataLine >= fileSize Then dataLine = fileSize - 1
   txtDataLine.Text = CStr(dataLine)
   txtRealLine.Text = CStr(intRecno(dataLine))
   txtLatitude.Text = Format(dLatitude(dataLine), "0000.00000")
   txtLongitude.Text = Format(dLongitude(dataLine), "0000.00000")
   txtGPSTime.Text = sTime(dataLine)
   txtDistance.Text = ""
   
End Sub
'
'use current GPS Lat/Long to compute distance from current Test Sign
'
Private Sub cmdDistance_Click()

   Dim dataLine As Long
   Dim distance As Double
   Dim lat1 As Double
   Dim long1 As Double
   Dim lat2 As Double
   Dim long2 As Double
   
   If bSignPostSelected = True Then
      'fetch selected sign post Lat/Long
      lat2 = LatLongToDegrees(dLatitude2)
      long2 = LatLongToDegrees(dLongitude2)
   
      'fetch index to current Lat/Long
      dataLine = CLng(txtDataLine.Text)
      If dataLine < 1 Then dataLine = 1
      If dataLine >= fileSize Then dataLine = fileSize - 1
      txtDataLine.Text = CStr(dataLine)
      lat1 = LatLongToDegrees(dLatitude(dataLine))
      long1 = LatLongToDegrees(dLongitude(dataLine))
   
      'calculate and display distance
      distance = GreatCircleDistance(lat1, long1, lat2, long2)
      txtDistance.Text = Format(distance, "0000.00") + " m"
   Else
      MsgBox ("You must first select a Sign Post reference!")
   End If
   
End Sub
'
'decrement current Fixation counter
'
Private Sub cmdFixationBack_Click()

   Dim temp As Integer
   temp = CInt(txtFixation.Text)
   temp = temp - 1
   If temp < 1 Then temp = 1
   txtFixation.Text = CStr(temp)
   
End Sub
'
'increment current Fixation counter
'
Private Sub cmdFixationNext_Click()

   Dim temp As Integer
   temp = CInt(txtFixation.Text)
   temp = temp + 1
   If temp > 10 Then temp = 10
   txtFixation.Text = CStr(temp)
   
End Sub

'
'
'advance VIDEO by single frame
'
Private Sub cmdFrameForward_Click()
   Dim intFrame As Long
   If intNFrames > 0 Then
      intFrame = CLng(txtCurrentFrame.Text)
      intFrame = intFrame + 1
      If intFrame > intNFrames Then
         intFrame = intNFrames
      End If
         'strPosition$ = CStr(intFrame)
         'CmdStr$ = "play " + MMControl1.FileName + " from " + strPosition$ + " to " + strPosition$
         'ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
         MMControl1.Frames = 1&
         MMControl1.Command = "Step" 'Step forward one video frame
   End If
End Sub
'
'

'
'reverse VIDEO by single frame
'
Private Sub cmdFrameBack_Click()
   Dim intFrame As Long
   If intNFrames > 0 Then
      intFrame = CLng(txtCurrentFrame.Text)
      intFrame = intFrame - 1
      If intFrame < 0 Then
         intFrame = 0
      End If
         strPosition$ = CStr(intFrame)
         CmdStr$ = "play " + currentVideoFile + " from " + strPosition$ + " to " + strPosition$
         ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
         '
         'the following does NOT work on my Win98 box
         'MMControl1.Frames = 1&
         'MMControl1.Command = "Back"
   End If
End Sub
'
'search for next GPS DATA line with specified Longitude
'
Private Sub cmdLongSearch_Click()
   Dim flag As Integer
   Dim index As Long
   
   flag = 0
   index = CLng(txtDataLine.Text)
   If index < 1 Then index = 1
   If index >= fileSize Then index = fileSize - 1
   Do While flag = 0
      If dLongitude(index) = CDbl(txtLongitude) Then
         flag = 1
       Else
         index = index + 1
         If index > fileSize Then
            index = fileSize
            flag = 1
         End If
       End If
   Loop
   
   txtDataLine.Text = CStr(index)
   txtRealLine.Text = CStr(intRecno(index))
   txtLatitude.Text = Format(dLatitude(index), "0000.00000")
   txtLongitude.Text = Format(dLongitude(index), "0000.00000")
   txtGPSTime.Text = sTime(index)
   txtDistance.Text = ""
     
End Sub

'
'search for next GPS DATA line with specified Latitude
'
Private Sub cmdLatSearch_Click()
   Dim flag As Integer
   Dim index As Long
   
   flag = 0
   index = 1
   txtDataLine.Text = CStr(index)
   Do While flag = 0
      If dLatitude(index) = CDbl(txtLatitude) Then
         flag = 1
       Else
         index = index + 1
         If index > fileSize Then
            index = fileSize
            flag = 1
         End If
       End If
   Loop
   
   txtDataLine.Text = CStr(index)
   txtRealLine.Text = CStr(intRecno(index))
   txtLatitude.Text = Format(dLatitude(index), "0000.00000")
   txtLongitude.Text = Format(dLongitude(index), "0000.00000")
   txtGPSTime.Text = sTime(index)
  txtDistance.Text = ""
  
End Sub
'
'record current fixation data to data log file
'
Private Sub cmdRecordData_Click()

   recordData
   
End Sub
'
'
'save current MS-Word fixation data log file
'
'
Private Sub cmdSaveDataLog_Click()

   wordApp.ActiveDocument.Save
   
End Sub

'
'
'search for next GPS DATA line with specified GPS Time
'
'
Private Sub cmdTimeSearch_Click()
   Dim flag As Integer
   Dim index As Long
   
   flag = 0
   index = 1
   txtDataLine.Text = CStr(index)
   Do While flag = 0
      If Left(sTime(index), 9) = Left(txtGPSTime.Text, 9) Then
         flag = 1
       Else
         index = index + 1
         If index > fileSize Then
            index = fileSize
            flag = 1
         End If
       End If
   Loop
   
   txtDataLine.Text = CStr(index)
   txtRealLine.Text = CStr(intRecno(index))
   txtLatitude.Text = Format(dLatitude(index), "0000.00000")
   txtLongitude.Text = Format(dLongitude(index), "0000.00000")
   txtGPSTime.Text = sTime(index)
  txtDistance.Text = ""
  
End Sub

'
'load a GPS DATA FILE via CommonDialog Box
'
Private Sub cmdLoadData_Click()

    Dim gpsFile As Integer
    Dim n As Integer
    Dim tempFileName As String
    
    'setup common dialog to prompt for GPS Data File selection
    tempFileName = CommonDialog1.FileName
    CommonDialog1.FileName = ""
    CommonDialog1.DialogTitle = "Choose GPS Data File"
    CommonDialog1.Filter = "GPS Data (*.DAT)|*.DAT|All Files|*.*"
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly + cdlOFNPathMustExist
    'show dialog box
    CommonDialog1.ShowOpen
    'exit without action upon CANCEL response
    If CommonDialog1.FileName = "" Then
       CommonDialog1.FileName = tempFileName
       Exit Sub
    End If
    
    'open and read GPS data file
    gpsFile = FreeFile() 'fetch an available file handle number
    n = 1                'initialize data counter
    Open CommonDialog1.FileName For Input As #gpsFile
    Do While ((n < MAXCOUNT) And (Not EOF(gpsFile)))
       Input #gpsFile, intRecno(n), sTime(n), intLatency(n), dLatitude(n), dLongitude(n), _
             dSpeed(n), dHeading(n), dPDOP(n), dHDOP(n), intStatus(n), lOdometer(n), _
             lAngleRate(n), dIntAngle(n)
       n = n + 1 'bump data counter
    Loop
    '
    n = n - 1     'adjust data counter
    fileSize = n  'save number of records in global variable
    Close (gpsFile)
    
    'update current GPS DATA filename
    currentDataFile = CommonDialog1.FileName
    
    'update feedback caption on user interface form
    txtCurrentData.Text = currentDataFile
    
    'update current latitude and longitude display
    txtDataLine.Text = CStr(1)
    txtRealLine.Text = CStr(intRecno(1))
    txtLatitude.Text = Format(dLatitude(1), "0000.00000")
    txtLongitude.Text = Format(dLongitude(1), "0000.00000")
    txtGPSTime.Text = sTime(1)
    txtDistance.Text = ""
    bSignPostSelected = False
    
    'enable related buttons
    cmdBackData.Enabled = True
    cmdNextData.Enabled = True
    cmdSyncData.Enabled = True
    cmdLatSearch.Enabled = True
    cmdLongSearch.Enabled = True
    cmdTimeSearch.Enabled = True
    cmdDistance.Enabled = True
    cmdRecordData.Enabled = True

    'close MS-Word data log document if currently open
    If wordFlag = True Then
       'make sure document has been saved
       wordApp.ActiveDocument.Save
       'quit Word
       wordApp.Quit
       'release resources
       Set wordApp = Nothing
       wordFlag = False
    End If
    
End Sub

'
'
'advance to next Lat/Long data line
'
'
Private Sub cmdNextData_Click()
   
   Dim dataLine As Long
   
   dataLine = CLng(txtDataLine.Text)
   dataLine = dataLine + 1
   If dataLine >= fileSize Then dataLine = fileSize - 1
   If dataLine < 1 Then dataLine = 1
   txtDataLine.Text = CStr(dataLine)
   txtRealLine.Text = CStr(intRecno(dataLine))
   txtLatitude.Text = Format(dLatitude(dataLine), "0000.00000")
   txtLongitude.Text = Format(dLongitude(dataLine), "0000.00000")
   txtGPSTime.Text = sTime(dataLine)
   txtDistance.Text = ""

End Sub
'
'
'Data-to-Video sync button
'
'
Private Sub cmdSyncData_Click()

   Dim dataLine As Long
   If syncFlag = False Then
      dataLine = CLng(txtDataLine.Text)
      If dataLine < 1 Then dataLine = 1
      If dataLine > fileSize Then dataLine = fileSize
      syncLine = dataLine
      syncFrame = CLng(txtCurrentFrame.Text)
      txtLatitude.Text = Format(dLatitude(dataLine), "0000.00000")
      txtLongitude.Text = Format(dLongitude(dataLine), "0000.00000")
      txtGPSTime.Text = sTime(dataLine)
      cmdSyncData.Caption = "Sync Off"
      syncFlag = True
    Else
      cmdSyncData.Caption = "Sync On"
      syncFlag = False
    End If
   
End Sub
'
'copy Current Frame to Starting Frame
'
Private Sub cmdUpdateStart_Click()

   txtFrameStart.Text = txtCurrentFrame.Text
   
End Sub

'
'service "File|Choose Video File" menu item
'
Private Sub cvf_Click()
    'simulate "Choose Video File" GUI button press
    cmdVideo.Value = True
End Sub
'
'service PLAY CLIP button
'
Private Sub cmdPlay_Click()
   'Play Video Clip from specified Start/End
   '(should do some error checking first)
   If MMControl1.FileName = "" Then Exit Sub
   CmdStr$ = "play " + currentVideoFile + " from " + txtFrameStart.Text + " to " + txtNFrames.Text
   ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
   cmdPause.Caption = "Pause"   'display PAUSE button caption
   cmdPause.Enabled = True
   'cmdStop.Enabled = True       'enable STOP button

End Sub

'
'service STOP button
'
Private Sub cmdStop_Click()

    MMControl1.Command = "Stop" 'built-in mciCommand
    cmdPause.Caption = "Continue"  'change CONTINUE to PAUSE button
    cmdStop.Enabled = False
    MMControl1.Command = "Pause"

End Sub

'
'service PAUSE/CONTINUE button
'
Private Sub cmdPause_Click()
    If cmdPause.Caption = "Pause" Then
        cmdPause.Caption = "Continue"
        MMControl1.Command = "Pause"
        'cmdStop.Enabled = False
    Else
        cmdPause.Caption = "Pause"
        CmdStr$ = "play " + currentVideoFile + " from " + txtCurrentFrame.Text + " to " + txtNFrames.Text
        ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
        'cmdStop.Enabled = True
    End If
    
End Sub

'
'service CHOOSE VIDEO button
Private Sub cmdVideo_Click()
    Dim strMsg As String * 255
    'setup common dialog to prompt for media selection
    CommonDialog1.DialogTitle = "Choose Video"
    CommonDialog1.Filter = "Video for Windows (*.MPG)|*.MPG|All Files|*.*"
    CommonDialog1.Flags = cdlOFNFileMustExist + cdlOFNHideReadOnly + cdlOFNPathMustExist
    'show dialog box
    CommonDialog1.ShowOpen
    'exit without action upon CANCEL response
    If CommonDialog1.FileName = "" Then Exit Sub
    'auto-Close current media player
    MMControl1.Command = "Close"
    'pass selected media filename to media player
    MMControl1.FileName = CommonDialog1.FileName
    'update feedback caption on media player interface form
    filelabel.Caption = "Current Video: " & CommonDialog1.FileName
    '
    'update current video filename
    currentVideoFile = CommonDialog1.FileName
    '
    'enable PLAY button
    cmdPlay.Enabled = True
    '
    'open media file
    MMControl1.Command = "Open"
    'Put integrated PictureBox's window handle in CmdStr$
    CmdStr$ = "window " + MMControl1.FileName + " handle " + Format$(Picture1.hWnd)
    'Send window handle to mciSendString
    ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
    'Redirect video output to VB PictureBox
    CmdStr$ = "put " + MMControl1.FileName + " destination "
    ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
    '
    'fetch/echo video file length (in frames)
    CmdStr$ = "set " + MMControl1.FileName + " time format frames"
    ReturnVal& = mciSendString(CmdStr$, 0&, 0, 0&)
    CmdStr$ = "status " + MMControl1.FileName + " length"
    ReturnVal& = mciSendString(CmdStr$, strMsg, 255, 0&)
    txtNFrames.Text = LTrim$(strMsg)
    intNFrames = CLng(txtNFrames.Text)
    txtFrameStart.Text = "0"

End Sub
'
'Service SignPost Selection from the ListBox
'
Private Sub lstSignPost_Click()
   
   'activate SignPostSelected flag
   bSignPostSelected = True
   
   'parse selection
   If lstSignPost.Text = "01 - S7" Then
      dLatitude2 = dSignLat(1)
      dLongitude2 = dSignLong(1)
   End If
   If lstSignPost.Text = "02 - E3" Then
      dLatitude2 = dSignLat(2)
      dLongitude2 = dSignLong(2)
   End If
   If lstSignPost.Text = "03 - A6" Then
      dLatitude2 = dSignLat(3)
      dLongitude2 = dSignLong(3)
   End If
   If lstSignPost.Text = "04 - State" Then
      dLatitude2 = dSignLat(4)
      dLongitude2 = dSignLong(4)
   End If
   If lstSignPost.Text = "05 - Grape" Then
      dLatitude2 = dSignLat(5)
      dLongitude2 = dSignLong(5)
   End If
   If lstSignPost.Text = "06 - H4" Then
      dLatitude2 = dSignLat(6)
      dLongitude2 = dSignLong(6)
   End If
   If lstSignPost.Text = "07 - T5" Then
      dLatitude2 = dSignLat(7)
      dLongitude2 = dSignLong(7)
   End If
   If lstSignPost.Text = "08 - X8" Then
      dLatitude2 = dSignLat(8)
      dLongitude2 = dSignLong(8)
   End If
   If lstSignPost.Text = "09 - Z9" Then
      dLatitude2 = dSignLat(9)
      dLongitude2 = dSignLong(9)
   End If
   If lstSignPost.Text = "10 - Dream" Then
      dLatitude2 = dSignLat(10)
      dLongitude2 = dSignLong(10)
   End If
   If lstSignPost.Text = "11 - Power" Then
      dLatitude2 = dSignLat(11)
      dLongitude2 = dSignLong(11)
   End If
   If lstSignPost.Text = "12 - C1" Then
      dLatitude2 = dSignLat(12)
      dLongitude2 = dSignLong(12)
   End If
   If lstSignPost.Text = "14 - Crown" Then
      dLatitude2 = dSignLat(14)
      dLongitude2 = dSignLong(14)
   End If
   If lstSignPost.Text = "15 - A7" Then
      dLatitude2 = dSignLat(15)
      dLongitude2 = dSignLong(15)
   End If
   If lstSignPost.Text = "16 - E4" Then
      dLatitude2 = dSignLat(16)
      dLongitude2 = dSignLong(16)
   End If
   If lstSignPost.Text = "17 - T3" Then
      dLatitude2 = dSignLat(17)
      dLongitude2 = dSignLong(17)
   End If
   If lstSignPost.Text = "18 - Apple" Then
      dLatitude2 = dSignLat(18)
      dLongitude2 = dSignLong(18)
   End If
   If lstSignPost.Text = "19 - H5" Then
      dLatitude2 = dSignLat(19)
      dLongitude2 = dSignLong(19)
   End If

End Sub

'
'update Current Video Frame counter
'
Private Sub MMControl1_StatusUpdate()
   Dim dataLine As Long
   'update frame counter as video plays
   txtCurrentFrame.Text = CStr(MMControl1.Position)
   '
   'synchronous update and display of data file pointer
   If syncFlag = True Then
      dataLine = CLng(txtCurrentFrame.Text) - syncFrame
      dataLine = syncLine + Int(dataLine / 3) - 1
      If dataLine >= fileSize Then dataLine = fileSize
      If dataLine < 1 Then dataLine = 1 'trap zero
      txtDataLine.Text = CStr(dataLine)
      txtRealLine.Text = CStr(intRecno(dataLine))
      txtLatitude.Text = Format(dLatitude(dataLine), "0000.00000")
      txtLongitude.Text = Format(dLongitude(dataLine), "0000.00000")
      txtGPSTime.Text = sTime(dataLine)
   End If
End Sub

'
'start-up initialization code
'
Private Sub Form_Load()
    'initialize MCI control
    MMControl1.Notify = True
    MMControl1.Wait = True
    MMControl1.Shareable = False
    MMControl1.UpdateInterval = 100 '100 msec status update rate
    MMControl1.DeviceType = "MPEGVideo" 'select MM Player for AVI/MPEG-1/MPEG-2 video
    'display message in label nested in integrated PictureBox
    Label1.Caption = "Video output is in the Video window. To turn this option off, do the following:" & Chr(10) & Chr(10) & "1. Stop any playing video." & Chr(10) & "2. Choose the 'Play in Seperate Window' option in the File menu."
    '
    'position main form
    '(center)
    Forms(0).Left = (Screen.Width - Forms(0).Width) / 2
    Forms(0).Top = (Screen.Height - Forms(0).Height) / 2
    '(top left corner)
    Forms(0).Left = 1
    Forms(0).Top = 1
    '
    txtCurrentFrame.Text = "0"
    intNFrames = 0 'clear media length parm
    fileSize = 0
    syncFlag = False
    fieldCounter = 0
    bSignPostSelected = False 'disable distance calcualtions untill sign selected
    currentVideoFile = ""
    currentDataFile = ""
    wordFlag = False  'no MS-Word document is open
    '
    'initialize Stimulus Sign Post Selection List
    '
    lstSignPost.AddItem "01 - S7"
    lstSignPost.AddItem "02 - E3"
    lstSignPost.AddItem "03 - A6"
    lstSignPost.AddItem "04 - State"
    lstSignPost.AddItem "05 - Grape"
    lstSignPost.AddItem "06 - H4"
    lstSignPost.AddItem "07 - T5"
    lstSignPost.AddItem "08 - X8"
    lstSignPost.AddItem "09 - Z9"
    lstSignPost.AddItem "10 - Dream"
    lstSignPost.AddItem "11 - Power"
    lstSignPost.AddItem "12 - C1"
    lstSignPost.AddItem "14 - Crown"
    lstSignPost.AddItem "15 - A7"
    lstSignPost.AddItem "16 - E4"
    lstSignPost.AddItem "17 - T3"
    lstSignPost.AddItem "18 - Apple"
    lstSignPost.AddItem "19 - H5"
    '
    '
    'initialize test track sign locations
    'Format: DDMM.MMMMM  where D=deg, M=min
    'S7-1
    dSignLat(1) = 4447.72882
    dSignLong(1) = 9255.154474
    'E3-2
    dSignLat(2) = 4447.841837
    dSignLong(2) = 9255.249295
    'A6-3
    dSignLat(3) = 4447.941722
    dSignLong(3) = 9255.33604
    'STATE-4
    dSignLat(4) = 4448.076075
    dSignLong(4) = 9255.360736
    'GRAPE-5
    dSignLat(5) = 4447.982623
    dSignLong(5) = 9255.272952
    'H4-6
    dSignLat(6) = 4447.833405
    dSignLong(6) = 9255.174509
    'T5-7
    dSignLat(7) = 4447.707636
    dSignLong(7) = 9255.089752
    'X8-8
    dSignLat(8) = 4447.595896
    dSignLong(8) = 9255.017192
    'Z9-9
    dSignLat(9) = 4447.899001
    dSignLong(9) = 9255.147252
    'DREAM-10
    dSignLat(10) = 4448.012281
    dSignLong(10) = 9255.219618
    'POWER-11
    dSignLat(11) = 4448.001064
    dSignLong(11) = 9255.368726
    'C1-12
    dSignLat(12) = 4447.803919
    dSignLong(12) = 9255.227755
    'Skip Sign #13
    '
    'CROWN-14
    dSignLat(14) = 4447.605545
    dSignLong(14) = 9255.062768
    'A7-15
    dSignLat(15) = 4447.747881
    dSignLong(15) = 9255.108386
    'E4-16
    dSignLat(16) = 4447.911771
    dSignLong(16) = 9255.215853
    'T3-17
    dSignLat(17) = 4448.045845
    dSignLong(17) = 9255.303611
    'APPLE-18
    dSignLat(18) = 4448.023953
    dSignLong(18) = 9255.237282
    'H5-19
    dSignLat(19) = 4447.85111
    dSignLong(19) = 9255.129713
    '
End Sub
'
'
Private Sub Form_Unload(Cancel As Integer)
   
   'release any video files
   MMControl1.Command = "Close"
   
   'close MS-Word data log document if currently open
   If wordFlag = True Then
      'make sure document has been saved
      wordApp.ActiveDocument.Save
      'quit Word
      wordApp.Quit
      'release resources
      Set wordApp = Nothing
      wordFlag = False
   End If
   
End Sub

'
'service "HELP|About..." menu item
'
Private Sub mnuAVIView_Click()
    MsgBox "ETS Media Explorer" & Chr(10) & "Development shell for ETS scoring sortware" & Chr(10) & "This program is freeware/shareware." & Chr(10) & "Thanks to Visual Basic Workshop at http://www.orudge.freeuk.com", 64, "About ETS Media Explorer"
End Sub

'
'service File|Exit menu item
'
Private Sub mnuExit_Click()
    End
End Sub

'
'service Timer1 events
'
Private Sub Timer1_Timer()

    'deactivate PLAY button if no media file has been selected yet
    If Not filelabel.Caption = "Current Video: none" Then Exit Sub
    cmdPlay.Enabled = False   ' If filelabel is none then how can you play a file?
    cmdPause.Enabled = False
    
End Sub

'
'convert Latitude/Longitude data to degrees
'
Private Function LatLongToDegrees(LatLong As Double) As Double

   Dim str As String
   Dim degrees As Double
   Dim minutes As Double
   
   'parse data
   str = Format(LatLong, "0000.00000")
   degrees = CDbl(Left(str, 2))
   minutes = CDbl(Mid(str, 3, 8))
   '
   'convert to degrees
   LatLongToDegrees = degrees + (minutes / 60#)
   
End Function
'
'calculate distance between two points
'
Private Function GreatCircleDistance(lat1 As Double, long1 As Double, lat2 As Double, long2 As Double) As Double
                                      
   Dim a As Double
   Dim c As Double
   Dim d As Double
   Dim dlat As Double
   Dim dlong As Double
   
   'convert degrees to radians
   lat1 = lat1 / 57.29577951
   lat2 = lat2 / 57.29577951
   long1 = long1 / 57.29577951
   long2 = long2 / 57.29577951
   
   'calculate distance using Modified Haversine Formula
   'Sinnot, R.W. (1984) Virtues of the Haversine.
   'Sky and Telescope, 68(2), p. 159
   '
   dlong = long2 - long1
   dlat = lat2 - lat1
   a = Sin(dlat / 2#) * Sin(dlat / 2#)
   a = a + Cos(lat1) * Cos(lat2) * (Sin(dlong / 2#) * Sin(dlong / 2#))
   '
   'c = 2# * atan2(Sqr(a), Sqr(1# - a))
   '
   c = 2# * Atn(Sqr(a) / Sqr(1 - a))
   'multiply angle by radius of the earth (meters)
   d = c * 6367000#
   
   'return distance in meters
   GreatCircleDistance = d
   
End Function

'
'
'record fixation data to MS Word document
'
' TEST VERSION!!!!!!!!!!!!!!
'
Private Sub recordData()

   Dim index As Integer
   Dim msg As String
   
   'open MS-Word document if necessary
   If wordFlag = False Then
   
      'Create new instance of MS-Word 2002
      Set wordApp = CreateObject("Word.Application")
      
      'monospaced font (doesN'T WORK!!!!!!!!!!!!!!!!!!)
      'wordApp.Selection.Font.Name = "Courrier New"
      'wordApp.ActiveDocument.Paragraphs(1).Range.Font.Name = "Courrier New"
      
      'create a NEW/BLANK document
      wordApp.Documents.Add
      
      'show that WORD is now out there
      wordFlag = True
      'active Save Log button
      cmdSaveDataLog.Enabled = True
      
      '
      '
      'need to change FONT to Courrier (i.e., MONO-SPACED font)
      '
      '
      
      'write file header
      wordApp.Selection.TypeText "Fixation-Log" + Chr(13)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      wordApp.Selection.TypeText "Video File: " + currentVideoFile + Chr(13)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      wordApp.Selection.TypeText "Data File:  " + currentDataFile + Chr(13)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      wordApp.Selection.TypeText Chr(13)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      msg = "sign fix   dist  video   data  memo" + Chr(13)
      wordApp.Selection.TypeText (msg)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      msg = "---- ---   ----  -----   ----  ----" + Chr(13)
      wordApp.Selection.TypeText (msg)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      
      'write first record to MS-Word data log
      msg = "0"
      msg = Left(lstSignPost.Text, 2) + "  "
      msg = msg + Format(txtFixation.Text, "@@") + "  "
      msg = msg + Left(txtDistance.Text, 7) + "  "
      msg = msg + Format(txtCurrentFrame.Text, "@@@@@") + "  "
      msg = msg + Format(txtDataLine.Text, "@@@@@") + "  "
      msg = msg + txtMemo.Text + Chr(13)
      wordApp.Selection.TypeText (msg)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
      
      'name the current document via Save command
      'need some error code to trap CANCEL button response
      wordApp.ActiveDocument.Save
      'need to re-hide the MS-Word application
      wordApp.Visible = True
      
   Else
   
      'write current fixation data to Word document
      msg = "0"
      msg = Left(lstSignPost.Text, 2) + "  "
      msg = msg + Format(txtFixation.Text, "@@") + "  "
      msg = msg + Left(txtDistance.Text, 7) + "  "
      msg = msg + Format(txtCurrentFrame.Text, "@@@@@") + "  "
      msg = msg + Format(txtDataLine.Text, "@@@@@") + "  "
      msg = msg + txtMemo.Text + Chr(13)
      wordApp.Selection.TypeText (msg)
      wordApp.Selection.MoveDown Unit:=wdParagraph, Count:=1
     
   End If
      
End Sub




