%readfiledemo3.m
%uses TEXTSCAN to skip header and create separate data column arrays

%open text file for read-only access
%returns a handle to the file if successful, else -1
fid=fopen('fiodata3.txt');

%exit if file not opened successfully
if fid == -1
    %display error msg on console
    disp('Unable to open file: fiodata2.txt')
    %quit m-file
    return
end

%skip over two text header lines
fgetl(fid);
fgetl(fid);

%read data into an array of column arrays (i.e., AoA{1} and AoA{2})
AoA=textscan(fid,'%d %d %s');
%copy trial#'s into a column array
trials=AoA{1};
%copy stimulus durations (msec) into a column array
durations=AoA{2};
%copy stimulus image files to column array
images=AoA{3};

%close file prior to exit
fclose(fid);
