% fileio_tutorial.m
%
% Some simple examples of basic MATLAB file I/O operations:
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             Reading Data from an ASCII File
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%

%LOAD <filename.ext>
%Use the MATLAB LOAD <filename.ext> command to read columns of 
%numerical data from a space delineated ASCII text file.  Each 
%row of data is presumed to end with a new-line character. The
%data from each column in the file is imported into a MATLAB matrix
%bearing the same name as the file (without the suffix).

clear all;
load 'fiodata1.txt';   %read space delineated text file form a
                       %file named 'fiodata1.txt' into a matrix
                       %named 'fiodata1'.  Examine the matrix and
                       %compare it to the input file.

%The LOAD <filename.ext> command also works with comma and tab
%delineated ASCII text files. Try:

clear all;
load 'fiodata1.csv'    %comma delimited text file
                       %   or
clear all;             %
load 'fiodata1.tab'    %tab delimited text file      

%The most significant limitation of the LOAD <filename.ext> command
%is that is cannot be used to input none numerial data such as stimulus
%filenames.
%
%The TEXTREAD command can read both numeric and string data from an ASCII
%text file.  The general format of the command is:
%
%    textread( 'filename.ext','data-format-string');
%        where:
%             'data-format-string' described the format of each data column
%                 as well as the delineator(s) separating each data column
%
%The following example reads a 3-column ASCII text file that contains
%numerical data in columns 1 and 2 and string data in column 3.  The data
%columns are read into the MATLAB column vectors named trials, durations and
%filenames, respectively:

clear all;
[trials,durations,filenames]=textread('fiodata2.txt','%d %d %s');

%Examine the trials, durations and filenames vectors and compare their
%contents to the file.  If the file had been delimited using a comma or
%tab character, you would need to replace the blank in the
%data-format-string with a ',' or '\t', respectively.

%
%The dumpfile(filename) script contains an example of using the fgetl()
%low-level file command.  This script opens the specified file, loops
%through it and reads/displays each line in the file. for example:

dumpfile('fiodata3.txt')


%
%See the 'readfiledemo3.m' script for an example of how to use
%low level file I/O commands to skip over a descriptive header at
%the top of an ASCII data file and then recursively read two columns 
%of text data and a 3rd column of string data into a MATLAB
%array-of-arrays.

clear all;
readfiledemo3;


%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%             Writing Data to an ASCII File
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%

%FPRINTF( file-id, 'data-format-string', data-list...) is one of the most
%flexible low-level file I/O commands for saving formated MATLAB data to an
%ASCII file.  The following code snippet creates some data and then saves
%it to a newly created text file using the fopen()...fprintf()...fclose()
%sequence:

clear all;
%create some sample data
%short table of exponential function
x=[0.0:0.1:1.0];
y=exp(x);
%open new file in text-write-mode
[fid,message]=fopen('testdata.txt','wt') %'wt' = new text file for writing
%write (x,y) data pairs to disk file
%fprintf() is vectorized for nonscalar arguments (to improve speed).
%The function recycles the 'data-format-string' through the elements
%of the [x;y] 10x2 matrix in columnwise fashion until all of its
%rows have been used up.
count=fprintf(fid,'%6.3f,%6.3f\n',[x;y]); %'\n' adds new-line to end of each row
%close file
fclose(fid);

%
%Examine the contexts of the 'testdata.txt' file we justed saved to disk.
%

type testdata.txt

