function dumpfile(filename)
%    usage: dumpfile('filename')
%    reads text file and dumps it to the console

%open file for read-only access
%return handle to file if successful, else returns -1
fid=fopen(filename);
%exit if file does not open correctly
if fid == -1
    %display error message
    disp(strcat('Unable to open file-->',filename))
    disp('M-file terminated')
    %exit from M-file
    return
end
%loop thru file until end-of-file reached
%i.e., non-text data (-1) is returned to variable 'tline'
while 1   %start infinite while-loop
    %read next line of text from input file
    tline = fgetl(fid);
    %test for non-text/char input
    if ~ischar(tline)
        break  %exit out of infinite while-loop
    end
    %display text line on console
    disp(tline);
end
%close file prior to exit
fclose(fid);
    